@extends('layouts.admin')

@section('page_title', 'E-Paper Management')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Daily Newspaper Uploads</h3>
        <div class="card-tools">
            <a href="{{ route('admin.e-papers.create') }}" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> Upload New</a>
        </div>
    </div>
    <div class="card-body p-0">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Date</th>
                    <th>File</th>
                    <th style="width:100px">Action</th>
                </tr>
            </thead>
            <tbody>
                @forelse($epapers as $paper)
                <tr>
                    <td>{{ $paper->title }}</td>
                    <td>{{ $paper->date ? $paper->date->format('d M Y') : 'N/A' }}</td>
                    <td><a href="{{ asset('storage/'.$paper->pdf_path) }}" target="_blank" class="btn btn-outline-info btn-sm"><i class="fa fa-file-pdf"></i> View PDF</a></td>
                    <td>
                        <form action="{{ route('admin.e-papers.destroy', $paper->id) }}" method="POST" onsubmit="return confirm('Delete this e-paper?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr><td colspan="4" class="text-center text-muted py-4">No e-papers uploaded yet.</td></tr>
                @endforelse
            </tbody>
        </table>
    </div>
    @if($epapers->hasPages())
    <div class="card-footer">{{ $epapers->links() }}</div>
    @endif
</div>
@endsection
