@extends('layouts.admin')

@section('page_title', 'Ads Management')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">All Ads</h3>
        <div class="card-tools">
            <a href="{{ route('admin.ads.create') }}" class="btn btn-primary btn-sm">Add Ad</a>
        </div>
    </div>
    <div class="card-body p-0">
        <table class="table">
            <thead>
                <tr>
                    <th>Position</th>
                    <th>Type</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($ads as $ad)
                <tr>
                    <td>{{ $postition }}</td>
                    <td>{{ $ad->type }}</td>
                    <td>{{ $ad->status ? 'Active' : 'Inactive' }}</td>
                    <td><!-- Delete/Edit buttons --></td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
