<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class AccountActivatedNotification extends Notification
{
    use Queueable;

    private $user;

    public function __construct($user)
    {
        $this->user = $user;
    }

    public function via($notifiable): array
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable): MailMessage
    {
        return (new MailMessage)
                    ->subject('Your Reporter Account is Activated')
                    ->line('Congratulations! Your account as a reporter has been activated.')
                    ->action('Login to Dashboard', route('login'))
                    ->line('You can now download your ID Card and Appointment Letter.');
    }

    public function toArray($notifiable): array
    {
        return [
            'message' => 'Your reporter account has been activated.',
            'action_url' => route('dashboard'),
        ];
    }
}
