<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\NewsPost;
use Illuminate\Http\Request;

class NewsPostController extends Controller
{
    public function index()
    {
        $news = NewsPost::with(['category', 'user'])->latest()->get();
        return view('admin.news.index', compact('news'));
    }

    public function approve(NewsPost $news)
    {
        $news->update(['status' => 'approved']);
        
        $news->user->notify(new \App\Notifications\NewsApprovedNotification($news));

        return redirect()->route('admin.news.index')->with('success', 'News post approved successfully.');
    }

    public function destroy(NewsPost $news)
    {
        $news->delete();
        return back()->with('success', 'News post deleted successfully');
    }
}
