<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $user = auth()->user();
        
        if ($user->hasRole('admin')) {
            $stats = [
                'news_count'       => \App\Models\NewsPost::count(),
                'category_count'   => \App\Models\Category::count(),
                'ad_count'         => \App\Models\Ad::count(),
                'reporter_count'   => \App\Models\User::role('reporter')->count(),
                'total_views'      => \App\Models\PageView::count(),
                'today_views'      => \App\Models\PageView::whereDate('created_at', today())->count(),
                'subscriber_count' => \App\Models\Subscription::count(),
            ];
            return view('admin.dashboard', compact('stats'));
        }

        if ($user->hasRole('reporter')) {
            if ($user->status !== 'active') {
                return view('reporter.pending');
            }
            $stats = [
                'news_count'     => \App\Models\NewsPost::where('user_id', $user->id)->count(),
                'approved_count' => \App\Models\NewsPost::where('user_id', $user->id)->where('status', 'approved')->count(),
                'pending_count'  => \App\Models\NewsPost::where('user_id', $user->id)->where('status', 'pending')->count(),
                'view_count'     => \App\Models\NewsPost::where('user_id', $user->id)->sum('view_count'),
            ];
            return view('reporter.dashboard', compact('stats'));
        }

        return redirect('/');
    }
}
