

<?php $__env->startSection('page_title', 'Gallery Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Gallery Items</h3>
        <div class="card-tools">
            <div class="btn-group btn-group-sm me-2">
                <a href="<?php echo e(route('admin.gallery.index')); ?>" class="btn <?php echo e($type === 'all' ? 'btn-primary' : 'btn-outline-primary'); ?>">All</a>
                <a href="<?php echo e(route('admin.gallery.index', ['type' => 'photo'])); ?>" class="btn <?php echo e($type === 'photo' ? 'btn-primary' : 'btn-outline-primary'); ?>">Photos</a>
                <a href="<?php echo e(route('admin.gallery.index', ['type' => 'video'])); ?>" class="btn <?php echo e($type === 'video' ? 'btn-primary' : 'btn-outline-primary'); ?>">Videos</a>
            </div>
            <a href="<?php echo e(route('admin.gallery.create')); ?>" class="btn btn-success btn-sm"><i class="fa fa-plus"></i> Add Item</a>
        </div>
    </div>
    <div class="card-body p-0">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th style="width:80px">Preview</th>
                    <th>Title</th>
                    <th>Type</th>
                    <th>Description</th>
                    <th>Date</th>
                    <th style="width:100px">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td>
                        <?php if($item->type == 'photo'): ?>
                        <img src="<?php echo e(asset('storage/'.$item->media)); ?>" width="80" height="60" style="object-fit:cover; border-radius:4px;" alt="<?php echo e($item->title); ?>">
                        <?php else: ?>
                        <?php
                            $vid = $item->media;
                            if (str_contains($vid, 'youtube.com') || str_contains($vid, 'youtu.be')) {
                                preg_match('/(?:v=|youtu\.be\/)([a-zA-Z0-9_-]{11})/', $vid, $m);
                                $vid = $m[1] ?? $vid;
                            }
                        ?>
                        <img src="https://img.youtube.com/vi/<?php echo e($vid); ?>/default.jpg" width="80" height="60" style="object-fit:cover; border-radius:4px;" alt="<?php echo e($item->title); ?>">
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($item->title); ?></td>
                    <td><span class="badge <?php echo e($item->type === 'photo' ? 'bg-primary' : 'bg-danger'); ?>"><?php echo e(ucfirst($item->type)); ?></span></td>
                    <td><?php echo e(Str::limit($item->description, 50)); ?></td>
                    <td><?php echo e($item->created_at->format('d M Y')); ?></td>
                    <td>
                        <form action="<?php echo e(route('admin.gallery.destroy', $item->id)); ?>" method="POST" onsubmit="return confirm('Delete this item?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr><td colspan="6" class="text-center text-muted py-4">No gallery items found.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php if($galleries->hasPages()): ?>
    <div class="card-footer"><?php echo e($galleries->appends(['type' => $type])->links()); ?></div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\RABI\rabi\news-portal\resources\views/admin/gallery/index.blade.php ENDPATH**/ ?>