

<?php $__env->startSection('page_title', 'Subcategories'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">All Subcategories</h3>
                <div class="card-tools">
                    <a href="<?php echo e(route('admin.subcategories.create')); ?>" class="btn btn-primary btn-sm">Add New</a>
                </div>
            </div>
            <div class="card-body p-0">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Parent Category</th>
                            <th>Subcategory Name</th>
                            <th>Slug</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($subcategory->id); ?></td>
                            <td><?php echo e($subcategory->category->name); ?></td>
                            <td><?php echo e($subcategory->name); ?></td>
                            <td><?php echo e($subcategory->slug); ?></td>
                            <td>
                                <a href="<?php echo e(route('admin.subcategories.edit', $subcategory->id)); ?>" class="btn btn-info btn-sm">Edit</a>
                                <form action="<?php echo e(route('admin.subcategories.destroy', $subcategory->id)); ?>" method="POST" style="display:inline-block">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\RABI\rabi\news-portal\resources\views/admin/subcategories/index.blade.php ENDPATH**/ ?>