

<?php $__env->startSection('page_title', 'Manage Reporters'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">All Reporters</h3>
                <div class="card-tools">
                    <a href="<?php echo e(route('admin.reporters.create')); ?>" class="btn btn-primary btn-sm">Add New Reporter</a>
                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body table-responsive p-0">
                <table class="table table-hover text-nowrap">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Status</th>
                            <th>Date Joined</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $reporters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reporter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($reporter->id); ?></td>
                            <td><?php echo e($reporter->name); ?></td>
                            <td><?php echo e($reporter->email); ?></td>
                            <td>
                                <?php if($reporter->status == 'active'): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php elseif($reporter->status == 'pending'): ?>
                                    <span class="badge bg-warning">Pending</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Suspended</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($reporter->created_at->format('M d, Y')); ?></td>
                            <td>
                                <a href="<?php echo e(route('admin.reporters.edit', $reporter->id)); ?>" class="btn btn-sm btn-info">Edit Status</a>
                                <form action="<?php echo e(route('admin.reporters.destroy', $reporter->id)); ?>" method="POST" style="display:inline-block">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this reporter?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\RABI\rabi\news-portal\resources\views/admin/reporters/index.blade.php ENDPATH**/ ?>