<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="row">
        <!-- Featured News -->
        <div class="col-md-8">
            <h3>Featured News</h3>
            <div id="featuredCarousel" class="carousel slide" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <?php $__currentLoopData = $featured; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="carousel-item <?php echo e($index == 0 ? 'active' : ''); ?>">
                        <img src="<?php echo e(asset('storage/'.$post->image)); ?>" class="d-block w-100" alt="<?php echo e($post->title); ?>">
                        <div class="carousel-caption d-none d-md-block">
                            <h5><?php echo e($post->title); ?></h5>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <h3 class="mt-4">Recent News</h3>
            <div class="row">
                <?php $__currentLoopData = $recent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6 mb-3">
                    <div class="card">
                        <img src="<?php echo e(asset('storage/'.$post->image)); ?>" class="card-img-top">
                        <div class="card-body">
                            <h5 class="card-title"><?php echo e($post->title); ?></h5>
                            <a href="<?php echo e(route('news.show', $post->slug)); ?>" class="btn btn-sm btn-primary">Read More</a>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php echo e($recent->links()); ?>

        </div>

        <!-- Sidebar -->
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header">Search News</div>
                <div class="card-body">
                    <form action="<?php echo e(route('news.search')); ?>" method="GET">
                        <input type="text" name="query" class="form-control mb-2" placeholder="Keyword...">
                        <button class="btn btn-primary w-100">Search</button>
                    </form>
                </div>
            </div>

            <div class="card mb-4">
                <div class="card-header">Categories</div>
                <div class="list-group list-group-flush">
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('news.category', $cat->slug)); ?>" class="list-group-item"><?php echo e($cat->name); ?> (<?php echo e($cat->newsPosts->count()); ?>)</a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <div class="card mb-4">
                <div class="card-header">Subscribe</div>
                <div class="card-body">
                    <p class="small text-muted">Get push notifications for breaking news.</p>
                    <form action="<?php echo e(route('subscribe')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="email" name="email" class="form-control mb-2" placeholder="Your Email" required>
                        <button class="btn btn-dark w-100">Subscribe Now</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
    // Mock Push Notification Permission Request
    window.addEventListener('load', () => {
        if ("Notification" in window) {
            if (Notification.permission !== "granted" && Notification.permission !== "denied") {
                setTimeout(() => {
                    if(confirm("Would you like to receive browser notifications for breaking news?")) {
                        Notification.requestPermission().then(permission => {
                            if (permission === "granted") {
                                console.log("Notification permission granted.");
                                alert("Thank you! You will now receive notifications.");
                            }
                        });
                    }
                }, 5000);
            }
        }
    });
</script>
<?php if(session('success')): ?>
    <script>alert("<?php echo e(session('success')); ?>");</script>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\RABI\rabi\news-portal\resources\views/welcome.blade.php ENDPATH**/ ?>