<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>News Portal | Dashboard</title>
    <!-- AdminLTE CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('adminlte/dist/css/adminlte.min.css')); ?>">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <?php echo $__env->yieldPushContent('css'); ?>
</head>
<body class="layout-fixed sidebar-expand-lg bg-body-tertiary">
    <div class="app-wrapper">
        <!-- Header -->
        <nav class="app-header navbar navbar-expand bg-body">
            <div class="container-fluid">
                <ul class="navbar-nav">
                    <li class="nav-item"> <a class="nav-link" data-lte-toggle="sidebar" href="#" role="button"> <i class="fa-solid fa-bars"></i> </a> </li>
                </ul>
                <ul class="navbar-nav ms-auto">
                    <!-- Notifications -->
                    <li class="nav-item dropdown">
                        <a class="nav-link" data-bs-toggle="dropdown" href="#">
                            <i class="fa-regular fa-bell"></i>
                            <?php if(Auth::user()->unreadNotifications->count() > 0): ?>
                                <span class="navbar-badge badge bg-warning text-dark"><?php echo e(Auth::user()->unreadNotifications->count()); ?></span>
                            <?php endif; ?>
                        </a>
                        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                            <span class="dropdown-item dropdown-header"><?php echo e(Auth::user()->unreadNotifications->count()); ?> Notifications</span>
                            <div class="dropdown-divider"></div>
                            <?php $__empty_1 = true; $__currentLoopData = Auth::user()->unreadNotifications->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <a href="<?php echo e($notification->data['action_url'] ?? '#'); ?>" class="dropdown-item">
                                    <i class="fa-solid fa-circle-info me-2 text-primary"></i> 
                                    <span class="text-wrap"><?php echo e(Str::limit($notification->data['message'] ?? 'Notification', 40)); ?></span>
                                    <div class="text-muted small"><?php echo e($notification->created_at->diffForHumans()); ?></div>
                                </a>
                                <div class="dropdown-divider"></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="dropdown-item text-center text-muted">No new notifications</div>
                                <div class="dropdown-divider"></div>
                            <?php endif; ?>
                            <a href="#" class="dropdown-item dropdown-footer text-center">See All Notifications</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown user-menu">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">
                            <img src="<?php echo e(Auth::user()->profile_photo ? asset('storage/'.Auth::user()->profile_photo) : asset('adminlte/assets/img/user2-160x160.jpg')); ?>" class="user-image rounded-circle shadow-sm" alt="User Image" style="width: 30px; height: 30px; object-fit: cover;">
                            <span class="d-none d-md-inline"><?php echo e(Auth::user()->name); ?></span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                            <li class="user-footer">
                                <form method="POST" action="<?php echo e(route('logout')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-default btn-flat float-end">Sign out</button>
                                </form>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </nav>
        <!-- Sidebar -->
        <aside class="app-sidebar bg-body-secondary shadow" data-bs-theme="dark">
            <div class="sidebar-brand">
                <a href="<?php echo e(route('dashboard')); ?>" class="brand-link">
                    <span class="brand-text fw-light">News Portal</span>
                </a>
            </div>
            <div class="sidebar-wrapper">
                <nav class="mt-2">
                    <ul class="nav sidebar-menu flex-column" data-lte-toggle="treeview" role="menu" data-accordion="false">
                        <li class="nav-item">
                            <a href="<?php echo e(route('dashboard')); ?>" class="nav-link <?php echo e(request()->is('dashboard') ? 'active' : ''); ?>">
                                <i class="nav-icon fa-solid fa-gauge-high"></i>
                                <p>Dashboard</p>
                            </a>
                        </li>
                        <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
                        <li class="nav-header">ADMINISTRATION</li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.roles.index')); ?>" class="nav-link <?php echo e(request()->is('admin/roles*') ? 'active' : ''); ?>">
                                <i class="nav-icon fa-solid fa-lock"></i>
                                <p>Role Permissions</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.categories.index')); ?>" class="nav-link <?php echo e(request()->is('admin/categories*') ? 'active' : ''); ?>">
                                <i class="nav-icon fa-solid fa-list"></i>
                                <p>Categories</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.subcategories.index')); ?>" class="nav-link <?php echo e(request()->is('admin/subcategories*') ? 'active' : ''); ?>">
                                <i class="nav-icon fa-solid fa-code-branch"></i>
                                <p>Subcategories</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.reporters.index')); ?>" class="nav-link <?php echo e(request()->is('admin/reporters*') ? 'active' : ''); ?>">
                                <i class="nav-icon fa-solid fa-users"></i>
                                <p>Manage Reporters</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.ads.index')); ?>" class="nav-link <?php echo e(request()->is('admin/ads*') ? 'active' : ''); ?>">
                                <i class="nav-icon fa-solid fa-rectangle-ad"></i>
                                <p>Advertisements</p>
                            </a>
                        </li>
                        <li class="nav-header">MEDIA & TOOLS</li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.gallery.index')); ?>" class="nav-link <?php echo e(request()->is('admin/gallery*') ? 'active' : ''); ?>">
                                <i class="nav-icon fa-solid fa-images"></i>
                                <p>Gallery</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.e-papers.index')); ?>" class="nav-link <?php echo e(request()->is('admin/e-papers*') ? 'active' : ''); ?>">
                                <i class="nav-icon fa-solid fa-file-pdf"></i>
                                <p>E-Papers</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.analytics')); ?>" class="nav-link <?php echo e(request()->is('admin/analytics*') ? 'active' : ''); ?>">
                                <i class="nav-icon fa-solid fa-chart-line"></i>
                                <p>Analytics</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(url('/sitemap.xml')); ?>" class="nav-link" target="_blank">
                                <i class="nav-icon fa-solid fa-sitemap"></i>
                                <p>Sitemap <i class="fa fa-external-link-alt small ms-1"></i></p>
                            </a>
                        </li>
                        <?php endif; ?>
                        <li class="nav-header">NEWS CONTENT</li>
                        <li class="nav-item">
                            <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
                            <a href="<?php echo e(route('admin.news.index')); ?>" class="nav-link <?php echo e(request()->is('admin/news*') ? 'active' : ''); ?>">
                                <i class="nav-icon fa-solid fa-newspaper"></i>
                                <p>All News</p>
                            </a>
                            <?php else: ?>
                            <a href="<?php echo e(route('reporter.news.index')); ?>" class="nav-link <?php echo e(request()->is('reporter/news') ? 'active' : ''); ?>">
                                <i class="nav-icon fa-solid fa-newspaper"></i>
                                <p>My News</p>
                            </a>
                            <?php endif; ?>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('reporter.news.create')); ?>" class="nav-link <?php echo e(request()->is('reporter/news/create') ? 'active' : ''); ?>">
                                <i class="nav-icon fa-solid fa-plus"></i>
                                <p>Submit News</p>
                            </a>
                        </li>
                        <?php if (\Illuminate\Support\Facades\Blade::check('role', 'reporter')): ?>
                        <li class="nav-header">REPORTER SERVICES</li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('reporter.idcard')); ?>" class="nav-link">
                                <i class="nav-icon fa-solid fa-id-card"></i>
                                <p>My ID Card</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('reporter.appointment')); ?>" class="nav-link">
                                <i class="nav-icon fa-solid fa-file-pdf"></i>
                                <p>Appointment Letter</p>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </nav>
            </div>
        </aside>
        <!-- Main Content -->
        <main class="app-main">
            <div class="app-content-header">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-6">
                            <h3 class="mb-0"><?php echo $__env->yieldContent('page_title', 'Dashboard'); ?></h3>
                        </div>
                    </div>
                </div>
            </div>
            <div class="app-content">
                <div class="container-fluid">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?php echo e(session('error')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>

                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>

                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </main>
    </div>
    <!-- AdminLTE JS -->
    <script src="<?php echo e(asset('adminlte/dist/js/adminlte.min.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <?php echo $__env->yieldPushContent('js'); ?>
</body>
</html>
<?php /**PATH D:\RABI\rabi\news-portal\resources\views/layouts/admin.blade.php ENDPATH**/ ?>