

<?php $__env->startSection('page_title', 'Submit News'); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-primary">
    <form action="<?php echo e(route('reporter.news.store')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="card-body">
            <div class="form-group">
                <label>Title</label>
                <input type="text" name="title" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Category</label>
                <select name="category_id" id="category_id" class="form-control" required>
                    <option value="">Select Category</option>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form-group">
                <label>Subcategory</label>
                <select name="subcategory_id" id="subcategory_id" class="form-control">
                    <option value="">Select Subcategory</option>
                </select>
            </div>
<?php $__env->startPush('js'); ?>
<script>
    const categories = <?php echo json_encode($categories, 15, 512) ?>;
    document.getElementById('category_id').addEventListener('change', function() {
        const catId = this.value;
        const subSelect = document.getElementById('subcategory_id');
        subSelect.innerHTML = '<option value="">Select Subcategory</option>';
        
        const category = categories.find(c => c.id == catId);
        if (category && category.subcategories) {
            category.subcategories.forEach(sub => {
                const opt = document.createElement('option');
                opt.value = sub.id;
                opt.text = sub.name;
                subSelect.add(opt);
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>
            <div class="form-group">
                <label>Content</label>
                <textarea name="content" class="form-control" rows="10" required></textarea>
            </div>
            <div class="form-group">
                <label>Image</label>
                <input type="file" name="image" class="form-control">
            </div>
            <hr>
            <h5>SEO Meta Tags</h5>
            <div class="form-group">
                <label>Meta Title</label>
                <input type="text" name="meta_title" class="form-control">
            </div>
        </div>
        <div class="card-footer">
            <button type="submit" class="btn btn-primary">Submit News</button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\RABI\rabi\news-portal\resources\views/reporter/news/create.blade.php ENDPATH**/ ?>