

<?php $__env->startSection('page_title', 'My Submitted News'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Track Approval Status</h3>
                <div class="card-tools">
                    <a href="<?php echo e(route('reporter.news.create')); ?>" class="btn btn-primary btn-sm">Submit New News</a>
                </div>
            </div>
            <div class="card-body p-0">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Category</th>
                            <th>Status</th>
                            <th>Views</th>
                            <th>Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($post->title); ?></td>
                            <td><?php echo e($post->category->name); ?></td>
                            <td>
                                <?php if($post->status == 'approved'): ?>
                                    <span class="badge bg-success">Approved</span>
                                <?php elseif($post->status == 'pending'): ?>
                                    <span class="badge bg-warning text-dark">Pending Review</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Rejected</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($post->view_count); ?></td>
                            <td><?php echo e($post->created_at->format('M d, Y')); ?></td>
                            <td>
                                <a href="<?php echo e(route('reporter.news.edit', $post->id)); ?>" class="btn btn-sm btn-info">Edit</a>
                                <form action="<?php echo e(route('reporter.news.destroy', $post->id)); ?>" method="POST" style="display:inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete this post?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\RABI\rabi\news-portal\resources\views/reporter/news/index.blade.php ENDPATH**/ ?>