

<?php $__env->startSection('page_title', 'Add to Gallery'); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-info">
    <form action="<?php echo e(route('admin.gallery.store')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="card-body">
            <div class="form-group mb-3">
                <label>Title <span class="text-danger">*</span></label>
                <input type="text" name="title" class="form-control" value="<?php echo e(old('title')); ?>" required>
            </div>
            <div class="form-group mb-3">
                <label>Type <span class="text-danger">*</span></label>
                <select name="type" class="form-control" id="gallery_type">
                    <option value="photo" <?php echo e(old('type') === 'video' ? '' : 'selected'); ?>>Photo</option>
                    <option value="video" <?php echo e(old('type') === 'video' ? 'selected' : ''); ?>>Video</option>
                </select>
            </div>
            <div class="form-group mb-3" id="photo_field">
                <label>Select Photo</label>
                <input type="file" name="photo" class="form-control" accept="image/*">
            </div>
            <div class="form-group mb-3" id="video_field" style="display:none">
                <label>YouTube Video ID / URL</label>
                <input type="text" name="media" class="form-control" placeholder="e.g. dQw4w9WgXcQ or https://youtube.com/watch?v=...">
            </div>
            <div class="form-group mb-3">
                <label>Description (optional)</label>
                <textarea name="description" class="form-control" rows="3"><?php echo e(old('description')); ?></textarea>
            </div>
        </div>
        <div class="card-footer">
            <button type="submit" class="btn btn-primary">Save Gallery Item</button>
            <a href="<?php echo e(route('admin.gallery.index')); ?>" class="btn btn-secondary">Cancel</a>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
document.getElementById('gallery_type').addEventListener('change', function() {
    document.getElementById('photo_field').style.display = this.value === 'photo' ? 'block' : 'none';
    document.getElementById('video_field').style.display = this.value === 'video' ? 'block' : 'none';
});
// Trigger on load
document.getElementById('gallery_type').dispatchEvent(new Event('change'));
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\RABI\rabi\news-portal\resources\views/admin/gallery/create.blade.php ENDPATH**/ ?>