@extends('layouts.app')

@section('content')
<div class="container py-4">
    <div class="row">
        <!-- Featured News -->
        <div class="col-md-8">
            <h3>Featured News</h3>
            <div id="featuredCarousel" class="carousel slide" data-bs-ride="carousel">
                <div class="carousel-inner">
                    @foreach($featured as $index => $post)
                    <div class="carousel-item {{ $index == 0 ? 'active' : '' }}">
                        <img src="{{ asset('storage/'.$post->image) }}" class="d-block w-100" alt="{{ $post->title }}">
                        <div class="carousel-caption d-none d-md-block">
                            <h5>{{ $post->title }}</h5>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>

            <h3 class="mt-4">Recent News</h3>
            <div class="row">
                @foreach($recent as $post)
                <div class="col-md-6 mb-3">
                    <div class="card">
                        <img src="{{ asset('storage/'.$post->image) }}" class="card-img-top">
                        <div class="card-body">
                            <h5 class="card-title">{{ $post->title }}</h5>
                            <a href="{{ route('news.show', $post->slug) }}" class="btn btn-sm btn-primary">Read More</a>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
            {{ $recent->links() }}
        </div>

        <!-- Sidebar -->
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header">Search News</div>
                <div class="card-body">
                    <form action="{{ route('news.search') }}" method="GET">
                        <input type="text" name="query" class="form-control mb-2" placeholder="Keyword...">
                        <button class="btn btn-primary w-100">Search</button>
                    </form>
                </div>
            </div>

            <div class="card mb-4">
                <div class="card-header">Categories</div>
                <div class="list-group list-group-flush">
                    @foreach($categories as $cat)
                    <a href="{{ route('news.category', $cat->slug) }}" class="list-group-item">{{ $cat->name }} ({{ $cat->newsPosts->count() }})</a>
                    @endforeach
                </div>
            </div>

            <div class="card mb-4">
                <div class="card-header">Subscribe</div>
                <div class="card-body">
                    <p class="small text-muted">Get push notifications for breaking news.</p>
                    <form action="{{ route('subscribe') }}" method="POST">
                        @csrf
                        <input type="email" name="email" class="form-control mb-2" placeholder="Your Email" required>
                        <button class="btn btn-dark w-100">Subscribe Now</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
<script>
    // Mock Push Notification Permission Request
    window.addEventListener('load', () => {
        if ("Notification" in window) {
            if (Notification.permission !== "granted" && Notification.permission !== "denied") {
                setTimeout(() => {
                    if(confirm("Would you like to receive browser notifications for breaking news?")) {
                        Notification.requestPermission().then(permission => {
                            if (permission === "granted") {
                                console.log("Notification permission granted.");
                                alert("Thank you! You will now receive notifications.");
                            }
                        });
                    }
                }, 5000);
            }
        }
    });
</script>
@if(session('success'))
    <script>alert("{{ session('success') }}");</script>
@endif
@endpush
