@extends('layouts.app')

@section('title', $post->meta_title ?: $post->title)
@section('meta_description', $post->meta_description ?: Str::limit(strip_tags($post->content), 160))

@push('seo')
<meta property="og:type" content="article">
<meta property="og:title" content="{{ $post->meta_title ?: $post->title }}">
<meta property="og:description" content="{{ $post->meta_description ?: Str::limit(strip_tags($post->content), 160) }}">
<meta property="og:url" content="{{ url()->current() }}">
@if($post->og_image || $post->image)
<meta property="og:image" content="{{ asset('storage/' . ($post->og_image ?: $post->image)) }}">
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
@endif
<meta property="og:site_name" content="{{ config('app.name') }}">
<meta property="article:published_time" content="{{ $post->created_at->toIso8601String() }}">
<meta property="article:modified_time" content="{{ $post->updated_at->toIso8601String() }}">
<meta property="article:section" content="{{ $post->category->name }}">
@if($post->meta_keywords)
<meta name="keywords" content="{{ $post->meta_keywords }}">
<meta property="article:tag" content="{{ $post->meta_keywords }}">
@endif
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="{{ $post->meta_title ?: $post->title }}">
<meta name="twitter:description" content="{{ $post->meta_description ?: Str::limit(strip_tags($post->content), 160) }}">
@if($post->og_image || $post->image)
<meta name="twitter:image" content="{{ asset('storage/' . ($post->og_image ?: $post->image)) }}">
@endif
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "NewsArticle",
    "headline": "{{ addslashes($post->title) }}",
    "description": "{{ addslashes($post->meta_description ?: Str::limit(strip_tags($post->content), 160)) }}",
    "url": "{{ url()->current() }}",
    "datePublished": "{{ $post->created_at->toIso8601String() }}",
    "dateModified": "{{ $post->updated_at->toIso8601String() }}",
    "author": {
        "@type": "Person",
        "name": "{{ addslashes($post->user->name) }}"
    },
    "publisher": {
        "@type": "Organization",
        "name": "{{ config('app.name') }}",
        "logo": {
            "@type": "ImageObject",
            "url": "{{ asset('favicon.ico') }}"
        }
    }
    @if($post->image)
    ,"image": {
        "@type": "ImageObject",
        "url": "{{ asset('storage/'.$post->image) }}"
    }
    @endif
}
</script>
@endpush

@section('content')
<div class="container py-4">
    <div class="row">
        <div class="col-md-9">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('news.category', $post->category->slug) }}">{{ $post->category->name }}</a></li>
                    <li class="breadcrumb-item active">{{ Str::limit($post->title, 50) }}</li>
                </ol>
            </nav>
            <h1>{{ $post->title }}</h1>
            <div class="text-muted mb-3">
                By {{ $post->user->name }} | {{ $post->created_at->format('M d, Y') }} | <i class="fa fa-eye"></i> {{ $post->view_count }}
                @auth
                <div class="mt-2 text-dark">
                    <form action="{{ route('news.like', $post->id) }}" method="POST" style="display:inline">
                        @csrf
                        <button type="submit" class="btn btn-outline-danger btn-sm">
                            <i class="{{ $post->likes->where('user_id', auth()->id())->count() ? 'fa-solid' : 'fa-regular' }} fa-heart"></i> Like ({{ $post->likes->count() }})
                        </button>
                    </form>
                    <form action="{{ route('news.bookmark', $post->id) }}" method="POST" style="display:inline">
                        @csrf
                        <button type="submit" class="btn btn-outline-warning btn-sm">
                            <i class="{{ $post->bookmarks->where('user_id', auth()->id())->count() ? 'fa-solid' : 'fa-regular' }} fa-bookmark"></i> Bookmark
                        </button>
                    </form>
                </div>
                @endauth
            </div>
            @if($post->image)
            <img src="{{ asset('storage/'.$post->image) }}" class="img-fluid rounded mb-4 w-100" alt="{{ $post->title }}">
            @endif
            <div class="content">
                {!! $post->content !!}
            </div>

            <div class="mt-4">
                <h5>Share this news:</h5>
                <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}" class="btn btn-primary btn-sm" target="_blank"><i class="fab fa-facebook"></i> Facebook</a>
                <a href="https://twitter.com/intent/tweet?url={{ urlencode(url()->current()) }}&text={{ urlencode($post->title) }}" class="btn btn-info btn-sm text-white" target="_blank"><i class="fab fa-twitter"></i> Twitter</a>
                <a href="https://api.whatsapp.com/send?text={{ urlencode($post->title.' '.url()->current()) }}" class="btn btn-success btn-sm" target="_blank"><i class="fab fa-whatsapp"></i> WhatsApp</a>
            </div>

            <hr>
            <h3>Comments</h3>
            @auth
            <form action="{{ route('comments.store', $post->id) }}" method="POST">
                @csrf
                <div class="form-group mb-2">
                    <textarea name="comment" class="form-control" placeholder="Write a comment..." required></textarea>
                </div>
                <button type="submit" class="btn btn-primary btn-sm">Post Comment</button>
            </form>
            @else
            <p>Please <a href="{{ route('login') }}">login</a> to comment.</p>
            @endauth

            <div class="mt-4">
                @foreach($post->comments as $comment)
                <div class="card mb-2">
                    <div class="card-body py-2">
                        <strong>{{ $comment->user->name }}</strong>
                        <p class="mb-0">{{ $comment->comment }}</p>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endsection
