<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>News Portal | Dashboard</title>
    <!-- AdminLTE CSS -->
    <link rel="stylesheet" href="{{ asset('adminlte/dist/css/adminlte.min.css') }}">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    @stack('css')
</head>
<body class="layout-fixed sidebar-expand-lg bg-body-tertiary">
    <div class="app-wrapper">
        <!-- Header -->
        <nav class="app-header navbar navbar-expand bg-body">
            <div class="container-fluid">
                <ul class="navbar-nav">
                    <li class="nav-item"> <a class="nav-link" data-lte-toggle="sidebar" href="#" role="button"> <i class="fa-solid fa-bars"></i> </a> </li>
                </ul>
                <ul class="navbar-nav ms-auto">
                    <!-- Notifications -->
                    <li class="nav-item dropdown">
                        <a class="nav-link" data-bs-toggle="dropdown" href="#">
                            <i class="fa-regular fa-bell"></i>
                            @if(Auth::user()->unreadNotifications->count() > 0)
                                <span class="navbar-badge badge bg-warning text-dark">{{ Auth::user()->unreadNotifications->count() }}</span>
                            @endif
                        </a>
                        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                            <span class="dropdown-item dropdown-header">{{ Auth::user()->unreadNotifications->count() }} Notifications</span>
                            <div class="dropdown-divider"></div>
                            @forelse(Auth::user()->unreadNotifications->take(5) as $notification)
                                <a href="{{ $notification->data['action_url'] ?? '#' }}" class="dropdown-item">
                                    <i class="fa-solid fa-circle-info me-2 text-primary"></i> 
                                    <span class="text-wrap">{{ Str::limit($notification->data['message'] ?? 'Notification', 40) }}</span>
                                    <div class="text-muted small">{{ $notification->created_at->diffForHumans() }}</div>
                                </a>
                                <div class="dropdown-divider"></div>
                            @empty
                                <div class="dropdown-item text-center text-muted">No new notifications</div>
                                <div class="dropdown-divider"></div>
                            @endforelse
                            <a href="#" class="dropdown-item dropdown-footer text-center">See All Notifications</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown user-menu">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">
                            <img src="{{ Auth::user()->profile_photo ? asset('storage/'.Auth::user()->profile_photo) : asset('adminlte/assets/img/user2-160x160.jpg') }}" class="user-image rounded-circle shadow-sm" alt="User Image" style="width: 30px; height: 30px; object-fit: cover;">
                            <span class="d-none d-md-inline">{{ Auth::user()->name }}</span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                            <li class="user-footer">
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <button type="submit" class="btn btn-default btn-flat float-end">Sign out</button>
                                </form>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </nav>
        <!-- Sidebar -->
        <aside class="app-sidebar bg-body-secondary shadow" data-bs-theme="dark">
            <div class="sidebar-brand">
                <a href="{{ route('dashboard') }}" class="brand-link">
                    <span class="brand-text fw-light">News Portal</span>
                </a>
            </div>
            <div class="sidebar-wrapper">
                <nav class="mt-2">
                    <ul class="nav sidebar-menu flex-column" data-lte-toggle="treeview" role="menu" data-accordion="false">
                        <li class="nav-item">
                            <a href="{{ route('dashboard') }}" class="nav-link {{ request()->is('dashboard') ? 'active' : '' }}">
                                <i class="nav-icon fa-solid fa-gauge-high"></i>
                                <p>Dashboard</p>
                            </a>
                        </li>
                        @role('admin')
                        <li class="nav-header">ADMINISTRATION</li>
                        <li class="nav-item">
                            <a href="{{ route('admin.roles.index') }}" class="nav-link {{ request()->is('admin/roles*') ? 'active' : '' }}">
                                <i class="nav-icon fa-solid fa-lock"></i>
                                <p>Role Permissions</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.categories.index') }}" class="nav-link {{ request()->is('admin/categories*') ? 'active' : '' }}">
                                <i class="nav-icon fa-solid fa-list"></i>
                                <p>Categories</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.subcategories.index') }}" class="nav-link {{ request()->is('admin/subcategories*') ? 'active' : '' }}">
                                <i class="nav-icon fa-solid fa-code-branch"></i>
                                <p>Subcategories</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.reporters.index') }}" class="nav-link {{ request()->is('admin/reporters*') ? 'active' : '' }}">
                                <i class="nav-icon fa-solid fa-users"></i>
                                <p>Manage Reporters</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.ads.index') }}" class="nav-link {{ request()->is('admin/ads*') ? 'active' : '' }}">
                                <i class="nav-icon fa-solid fa-rectangle-ad"></i>
                                <p>Advertisements</p>
                            </a>
                        </li>
                        <li class="nav-header">MEDIA & TOOLS</li>
                        <li class="nav-item">
                            <a href="{{ route('admin.gallery.index') }}" class="nav-link {{ request()->is('admin/gallery*') ? 'active' : '' }}">
                                <i class="nav-icon fa-solid fa-images"></i>
                                <p>Gallery</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.e-papers.index') }}" class="nav-link {{ request()->is('admin/e-papers*') ? 'active' : '' }}">
                                <i class="nav-icon fa-solid fa-file-pdf"></i>
                                <p>E-Papers</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.analytics') }}" class="nav-link {{ request()->is('admin/analytics*') ? 'active' : '' }}">
                                <i class="nav-icon fa-solid fa-chart-line"></i>
                                <p>Analytics</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('/sitemap.xml') }}" class="nav-link" target="_blank">
                                <i class="nav-icon fa-solid fa-sitemap"></i>
                                <p>Sitemap <i class="fa fa-external-link-alt small ms-1"></i></p>
                            </a>
                        </li>
                        @endrole
                        <li class="nav-header">NEWS CONTENT</li>
                        <li class="nav-item">
                            @role('admin')
                            <a href="{{ route('admin.news.index') }}" class="nav-link {{ request()->is('admin/news*') ? 'active' : '' }}">
                                <i class="nav-icon fa-solid fa-newspaper"></i>
                                <p>All News</p>
                            </a>
                            @else
                            <a href="{{ route('reporter.news.index') }}" class="nav-link {{ request()->is('reporter/news') ? 'active' : '' }}">
                                <i class="nav-icon fa-solid fa-newspaper"></i>
                                <p>My News</p>
                            </a>
                            @endrole
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('reporter.news.create') }}" class="nav-link {{ request()->is('reporter/news/create') ? 'active' : '' }}">
                                <i class="nav-icon fa-solid fa-plus"></i>
                                <p>Submit News</p>
                            </a>
                        </li>
                        @role('reporter')
                        <li class="nav-header">REPORTER SERVICES</li>
                        <li class="nav-item">
                            <a href="{{ route('reporter.idcard') }}" class="nav-link">
                                <i class="nav-icon fa-solid fa-id-card"></i>
                                <p>My ID Card</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('reporter.appointment') }}" class="nav-link">
                                <i class="nav-icon fa-solid fa-file-pdf"></i>
                                <p>Appointment Letter</p>
                            </a>
                        </li>
                        @endrole
                    </ul>
                </nav>
            </div>
        </aside>
        <!-- Main Content -->
        <main class="app-main">
            <div class="app-content-header">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-6">
                            <h3 class="mb-0">@yield('page_title', 'Dashboard')</h3>
                        </div>
                    </div>
                </div>
            </div>
            <div class="app-content">
                <div class="container-fluid">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    @yield('content')
                </div>
            </div>
        </main>
    </div>
    <!-- AdminLTE JS -->
    <script src="{{ asset('adminlte/dist/js/adminlte.min.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    @stack('js')
</body>
</html>
