@extends('layouts.app')

@section('title', 'E-Paper – Daily Newspaper')
@section('meta_description', 'Download daily digital newspaper editions in PDF format.')

@section('content')
<div class="container py-5">
    <div class="text-center mb-5">
        <h1 class="display-5 fw-bold"><i class="fas fa-file-pdf text-danger me-2"></i>E-Paper</h1>
        <p class="text-muted lead">Download our daily newspaper editions as PDF</p>
    </div>

    @if($epapers->count())
    <div class="row g-4">
        @foreach($epapers as $paper)
        <div class="col-sm-6 col-md-4 col-lg-3">
            <div class="card shadow-sm border-0 text-center h-100">
                <div class="card-body py-4">
                    <div class="mb-3">
                        <i class="fas fa-file-pdf fa-4x text-danger"></i>
                    </div>
                    <h6 class="fw-semibold mb-1">{{ $paper->title }}</h6>
                    <p class="text-muted small mb-3">
                        <i class="fas fa-calendar-alt me-1"></i>
                        {{ $paper->date ? $paper->date->format('d M Y') : 'N/A' }}
                    </p>
                    <a href="{{ asset('storage/' . $paper->pdf_path) }}" 
                       target="_blank"
                       class="btn btn-danger btn-sm w-100"
                       download>
                        <i class="fas fa-download me-1"></i> Download PDF
                    </a>
                </div>
            </div>
        </div>
        @endforeach
    </div>

    <div class="mt-4">{{ $epapers->links() }}</div>
    @else
    <div class="text-center py-5">
        <i class="fas fa-file-pdf fa-4x text-muted mb-3"></i>
        <p class="text-muted">No e-papers have been uploaded yet. Please check back soon.</p>
    </div>
    @endif
</div>
@endsection
