@extends('layouts.admin')

@section('page_title', 'Edit Subcategory')

@section('content')
<div class="row">
    <div class="col-md-6">
        <div class="card card-primary">
            <form action="{{ route('admin.subcategories.update', $subcategory->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="card-body">
                    <div class="form-group">
                        <label for="category_id">Parent Category</label>
                        <select name="category_id" id="category_id" class="form-control" required>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}" {{ $subcategory->category_id == $category->id ? 'selected' : '' }}>
                                    {{ $category->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="name">Subcategory Name</label>
                        <input type="text" name="name" class="form-control" id="name" value="{{ $subcategory->name }}" required>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Update</button>
                    <a href="{{ route('admin.subcategories.index') }}" class="btn btn-default">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
