<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Hash;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Create Permissions
        $permissions = [
            'manage categories',
            'manage subcategories',
            'manage news',
            'approve news',
            'manage users',
            'manage reporters',
            'manage comments',
            'manage ads',
            'manage gallery',
            'manage e-paper',
            'manage seo',
            'view analytics',
            'submit news',
            'edit own news',
            'view approval status',
            'download reporter docs',
            'comment',
            'like',
            'share',
            'bookmark',
        ];

        foreach ($permissions as $permission) {
            Permission::findOrCreate($permission);
        }

        // Create Roles and assign permissions

        // Admin Role
        $adminRole = Role::findOrCreate('admin');
        $adminRole->givePermissionTo(Permission::all());

        // Reporter Role
        $reporterRole = Role::findOrCreate('reporter');
        $reporterRole->givePermissionTo([
            'submit news',
            'edit own news',
            'view approval status',
            'download reporter docs',
        ]);

        // Public User Role
        $userRole = Role::findOrCreate('user');
        $userRole->givePermissionTo([
            'comment',
            'like',
            'share',
            'bookmark',
        ]);

        // Create Super Admin User
        $admin = User::updateOrCreate(
            ['email' => 'admin@newsportal.com'],
            [
                'name' => 'Super Admin',
                'password' => Hash::make('password'),
                'status' => 'active',
            ]
        );
        $admin->setRole('admin');

        // Create a Test Reporter
        $reporter = User::updateOrCreate(
            ['email' => 'reporter@newsportal.com'],
            [
                'name' => 'Test Reporter',
                'password' => Hash::make('password'),
                'status' => 'active',
            ]
        );
        $reporter->setRole('reporter');
    }
}
