<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class NewsApprovedNotification extends Notification
{
    use Queueable;

    private $post;

    public function __construct($post)
    {
        $this->post = $post;
    }

    public function via($notifiable): array
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable): MailMessage
    {
        return (new MailMessage)
                    ->subject('Your News Post is Approved!')
                    ->line('Your news post "' . $this->post->title . '" has been approved and is now live.')
                    ->action('View Post', route('news.show', $this->post->slug))
                    ->line('Thank you for your contribution!');
    }

    public function toArray($notifiable): array
    {
        return [
            'message' => 'Your news post "' . $this->post->title . '" has been approved.',
            'action_url' => route('news.show', $this->post->slug),
        ];
    }
}
