<?php

namespace App\Http\Middleware;

use App\Models\PageView;
use App\Models\NewsPost;
use Closure;
use Illuminate\Http\Request;

class TrackPageView
{
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        // Only track GET requests on public pages
        if ($request->isMethod('get') && !$request->is('admin/*', 'api/*', 'dashboard*', 'reporter/*', 'profile*', 'login', 'register')) {
            try {
                $data = [
                    'url'        => $request->path(),
                    'ip_address' => $request->ip(),
                    'user_agent' => $request->userAgent(),
                    'referer'    => $request->header('referer'),
                    'session_id' => session()->getId(),
                ];

                // If it's a news page, link to the post
                if ($request->is('news/*')) {
                    $slug = $request->segment(2);
                    $post = NewsPost::where('slug', $slug)->first();
                    if ($post) {
                        $data['news_post_id'] = $post->id;
                    }
                }

                PageView::create($data);
            } catch (\Exception $e) {
                // Silently fail - analytics should not break the app
            }
        }

        return $response;
    }
}
