<?php

namespace App\Http\Controllers;

use App\Models\Bookmark;
use App\Models\NewsPost;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class BookmarkController extends Controller
{
    public function toggle(NewsPost $post)
    {
        $bookmark = Bookmark::where('news_post_id', $post->id)->where('user_id', Auth::id())->first();
        if ($bookmark) {
            $bookmark->delete();
            return back()->with('success', 'Removed from bookmarks');
        }
        Bookmark::create([
            'news_post_id' => $post->id,
            'user_id' => Auth::id(),
        ]);
        return back()->with('success', 'Added to bookmarks');
    }

    public function index()
    {
        $bookmarks = Bookmark::with('newsPost')->where('user_id', Auth::id())->get();
        return view('user.bookmarks', compact('bookmarks'));
    }
}
